/*The code to prepare robustness of results in "Can Trade Costs Explain Why*/
/*Exchange Rate Volatility Doesn't Feed Into Consumer Prices"*/
/*robustness to using a larger set of partner countries*/
/*data set covers 1970-2000 only*/

	use "C:/DATA/tcostxrvol_manycountries.dta", clear
	log using "C:/DATA/tcostxrvol_manycountries.log", text replace

	preserve

/*telling stata it is a panel data set*/
	
	tsset group year

/*Actual inflation measures*/
/*These will be used as the benchmarks for comparison purposes*/
/*Consumer price inflation*/

	gen lcpihome = ln(cpihome)
	gen inflationc = 100*d.lcpihome
	label variable inflationc "CPI inflation"
	drop lcpihome

	gen lcpifor = ln(cpifor)
	gen inflationcfor = 100*d.lcpifor
	drop lcpifor

/*GDP deflator inflation is needed for Table 1*/
/*Home GDP deflator inflation*/

	gen pgdphome = gdpchome/gdpkhome
	gen lpgdphome = ln(pgdphome)
	gen inflationg = 100*d.lpgdphome
	label variable inflationg "Home GDP deflator inflation"
	drop lpgdphome

/*Foreign GDP deflator inflation*/

	gen pgdpfor = gdpcfor/gdpkfor
	gen lpgdpfor =  ln(pgdpfor)
	gen inflationgfor = 100*d.lpgdpfor
	label variable inflationgfor "Foreign GDP deflator inflation"
	drop lpgdpfor

/*Rescaling imports and generating imports from self*/
/*Generating expenditure shares*/
/*g is the ratio of output to value added*/
/*to run the gross output version of the results, set g=2*/

	gen g = 1

	egen totimsample = sum(imp), by(homecode year)
	gen expsh = (imp/totimsample)*(imphome/((g*gdphome)+imphome-exphome))
	replace expsh = ((g*gdphome)-exphome)/((g*gdphome)+imphome-exphome) if homecode==forcode
	
	gen impreg = (imp/totim)*imphome
	replace impreg = (g*gdphome)-exphome if homecode==forcode

/*Inflation contributions*/
/*Inflation predictions will be weighted averages of these objects*/

	gen p = ln(x) + ln(gdpcfor/gdpkfor)
	gen dp = 100*d.p

	gen pfor = - ln(x) + ln(gdpchome/gdpkhome)
	gen dpfor = 100*d.pfor

/*First set of predictions - use measured within-sample expenditure or import shares*/
/*Consumer price inflation prediction with actual within-sample expenditure shares*/

	gen expshma = 0.5*(expsh + l1.expsh)
	gen wdp1 = expshma*dp
	egen pred1 = sum(wdp1), by(homecode year)
	label variable pred1 "Actual shares"

/*Second set of predictions - use within-sample GDP shares*/
/*GDP shares CPI inflation prediction*/

	egen gdpsample = sum(gdpfor), by(homecode year)
	gen gdpsh = gdpfor/gdpsample
	gen gdpshma = 0.5*(gdpsh + l1.gdpsh)
	gen wdp3 = gdpshma*dp
	egen pred3 = sum(wdp3), by(homecode year)
	label variable pred3 "GDP shares"

/*Stuff for the tables and figures, and results mentioned in the text*/
/*only those that are affected by having a larger set of partner countries*/

/*Import coverage in the data*/
/*mentioned in the data section*/

	gen imcoverage = totimsample/totim
	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		sum imcoverage if forcode==homecode & homecode=="`i'"
	}

/*Stuff for Table 1 - st.dev. of exchange rate changes and cpi inflation*/
/*Stylized facts on volatility of CPI inflation*/
/*these are unchanged*/

/*Stylized facts on volatility of GDP deflator inflation*/
/*these are unchanged*/

/*Stylized facts on volatility of bilateral nominal exchange rates*/
/*have a wider set of partner countries here*/
/*standard deviation will not be over a balanced panel*/

	tsset group year
	gen lx = ln(x)
	gen dlx = 100*d.lx

	egen dlxm = mean(dlx), by(homecode forcode)
	gen ddlx = (dlx - dlxm)^2
	egen vardlx = mean(ddlx), by(homecode forcode)
	gen sddlx = vardlx^0.5
	bysort homecode: sum sddlx if year==2000 & homecode~=forcode
	drop dlxm ddlx vardlx sddlx

/*Table 2 is the gravity equation estimates*/
/*do not estimate a gravity equation for the bigger sample*/

/*Stuff for Table 3*/
/*First and second moments of CPI inflation, and the predictions*/
/*here the predictions take into account more partner countries*/

	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		tabstat inflationc pred1 pred3 if year>1970 & forcode==homecode & homecode=="`i'", stats(mean sd)
	}

/*Figures*/

	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		#delimit ;
		twoway (line inflationc year, clwidth(medthick)) (line pred1 year, clwidth(medthick) clpattern(dash)) 
			(line pred3 year, clwidth(medthick) clpattern(dash_dot)) 
			if year>1970 & forcode==homecode & homecode=="`i'", title(`i') 
			l1title(%) graphregion(fcolor(white)) saving("C:/DATA/`i'_morecountries.gph",replace);
		#delimit cr
	}


/*Stuff for Table 4 - decomposition into home and foreign components*/

	gen foreign = 1
	replace foreign = 0 if homecode==forcode
	gen home = 1
	replace home = 0 if homecode~=forcode

/*Actual shares*/

	gen expshmahome = expshma*home
	gen expshmaforg = expshma*foreign
	gen wdphome1 = expshmahome*dp
	gen wdpfor1 = expshmaforg*dp
	egen predhome1 = sum(wdphome1), by(homecode year)
	egen predforg1 = sum(wdpfor1), by(homecode year)
	label variable predhome1 "Inflation from domestic sources"
	label variable predforg1 "Inflation from foreign sources"
	drop expshmahome expshmaforg wdphome1 wdpfor1

/*GDP shares*/

	gen gdpshmahome = gdpshma*home
	gen gdpshmahfor = gdpshma*foreign
	gen wdphome3 = gdpshmahome*dp
	gen wdphfor3 = gdpshmahfor*dp
	egen predhome3 = sum(wdphome3), by(homecode year)
	egen predhfor3 = sum(wdphfor3), by(homecode year)
	label variable predhome3 "Inflation from domestic sources"
	label variable predhfor3 "Inflation from foreign sources"
	drop gdpshmahome gdpshmahfor wdphome3 wdphfor3

/*Decomposition of mean of CPI predictions into home and foreign components*/
/*Measured expenditure shares*/

	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		tabstat pred1 predhome1 predforg1 if year>1970 & forcode==homecode & homecode=="`i'", stats(mean)
	}

/*GDP shares*/

	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		tabstat pred3 predhome3 predhfor3 if year>1970 & forcode==homecode & homecode=="`i'", stats(mean)		
	}


/*Decomposition of variance of CPI predictions into home and foreign components*/
/*Measured expenditure shares*/
	
	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		correlate pred1 predhome1 predforg1 if year>1970 & forcode==homecode & homecode=="`i'", covariance
	}

/*GDP shares*/

	foreach i in AUS AUT BEL CAN DNK FIN FRA GER GRC IRL ITA JPN KOR MEX NLD NZL NOR PRT ESP SWE CHE TUR GBR USA {
		correlate pred3 predhome3 predhfor3 if year>1970 & forcode==homecode & homecode=="`i'", covariance
	}

/*Stuff for Table 5 - measured and predicted home share of expenditure*/

	bysort homecode: sum expsh if homecode==forcode
	bysort homecode: sum gdpsh if homecode==forcode

/*Stuff for Broda-Romalis suggestion: components of predicted inflation volatility*/
/*Stylized facts on volatility of inflation contributions*/

	egen dpm = mean(dp), by(homecode forcode)
	gen ddp = (dp - dpm)^2
	egen vardp = mean(ddp), by(homecode forcode)
	gen sddp = vardp^0.5
	bysort homecode: sum sddp if year==2000 & homecode~=forcode
	drop vardp ddp dpm

/*Correlation of import shares and volatility of inflation contributions*/
/*Actual import shares*/

	egen expshm = mean(expsh), by(homecode forcode)
	bysort homecode: correlate sddp expshm if year==2000 & forcode~=homecode, covariance
	drop expshm
	
/*GDP shares*/

	egen gdpshm = mean(gdpsh), by(homecode forcode)
	bysort homecode: correlate sddp gdpshm if year==2000 & forcode~=homecode, covariance
	drop gdpshm sddp


	restore, preserve

	capture log close
